<?php
$output = $title = $interval = $el_class = '';
extract( shortcode_atts( array(
	'title' => '',
	'interval' => 0,
	'el_class' => '',
	'style' => '',
	'outline_style' => '',
	'solid_style' => '',
	'content_color' => '',
	'custom_content_bg_color' => '',
	'custom_content_text_color' => '',
), $atts ) );

wp_enqueue_script( 'sm-jquery-ui-tabs' );
wp_enqueue_script( 'sm-jquery-ui-tabs-rotate' );

$id = sm_shortcode_unique_id( 'sm_vtabs' );
$element = 'sm_vtabs';

$css_class = 'sm_vtabs sm_content_element';
$css_gen = new Inline_CSS_Generator( "sm_vtabs", $id );
$scoped_css = '';

$style = sm_validate_with_array( $style, sm_get_vtabs_styles_array() );
if ('sm-style-outline' == $style ) {
	$css_class .= ' ' . $style;
	$outline_style = sm_validate_with_array( $outline_style, sm_get_vtabs_outline_styles_array() );
	if ( $outline_style != '' ) $css_class .= ' ' . $outline_style;
} else {
	$solid_style = sm_validate_with_array( $solid_style, sm_get_skins_array( true ) );
	if ( $solid_style != '' ) $css_class .= ' ' . $solid_style;

	$content_color = sm_validate_with_array( $content_color, sm_get_vtabs_content_bg_colors_array( true ) );

	if ( 'custom' == $content_color ) {
		$custom_colors = array();
		if ( !empty( $custom_content_bg_color ) ) $custom_colors['background-color'] = $custom_content_bg_color;
		if ( !empty( $custom_content_text_color ) ) $custom_colors['color'] = $custom_content_text_color;
		$scoped_css .= $css_gen->css( ".sm_tabs_wrapper .sm-panel-wrap", $custom_colors );
	} else {
		$css_class .= ' ' . $content_color;
	}
}


if ( !empty( $el_class ) ) $css_class .= sm_get_extra_class( $el_class );


$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';
$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';
$wrapper_attributes[] = 'data-interval="' . esc_attr( $interval ) . '"';

?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php sm_the_scoped_css( $scoped_css ); ?>
	<div class="sm_wrapper sm_tabs_wrapper ui-tabs clearfix">
		<?php echo sm_widget_title( array( 'title' => $title, 'extraclass' => $element . '_heading' ) ); ?>
		<ul class="sm_tabs_nav ui-tabs-nav">
			<?php
			preg_match_all( '/sm_tab([^\]]+)/i', $content, $matches, PREG_OFFSET_CAPTURE );
			$tab_titles = array();
			// Extract tab titles
			if ( isset( $matches[1] ) ) {
				$tab_titles = $matches[1];
			}
			foreach ( $tab_titles as $tab ) :
				$tab_atts = shortcode_parse_atts( $tab[0] );
				if ( isset( $tab_atts['title'] ) ) :
					$hash = '#tab-' . ( isset( $tab_atts['tab_id'] ) ? esc_attr( $tab_atts['tab_id'] ) : sanitize_title( $tab_atts['title'] ) );
					$icon = sm_get_icon_from_atts( $tab_atts, true );
					if ( !empty( $icon ) ) :
						$icon = '<i class="tab-icon ' . $icon . '"></i>';
					endif;
			?>
			<li><a href="<?php echo esc_url( $hash ); ?>" class="ui-tabs-anchor"><?php echo sm_do_kses( $icon ) . esc_html( $tab_atts['title'] ); ?></a></li>
			<?php
				endif;
			endforeach;
			?>
		</ul>
		<div class="sm-panel-wrap">
			<?php
			echo sm_js_remove_wpautop( $content );
			?>
		</div>
	</div>
</div>